<?php 

class Setting extends MY_Controller
{
    public $module_name;
	function __construct()
    {
        parent::__construct();

        $this->module_name = $this->router->fetch_module();

        $this->load->model('../extensions/'.$this->module_name.'/models/Company_model');               
        $this->load->model('../extensions/'.$this->module_name.'/models/Employee_log_model');               
        $this->load->library('email');
        $this->load->library('form_validation');
        $this->load->library('ckeditor');
        $this->load->library('ckfinder');

        $this->load->helper('url'); // for redirect
        $this->load->helper('timezone');

        $this->load->helper('ckeditor_helper');

        $this->user_id    = $this->session->userdata('user_id');
        $this->company_id = $this->session->userdata('current_company_id');

        $view_data['menu_on']          = true;
        $this->load->vars($view_data);
        
    }

    function policies()
    {
        $data       = array();
        global $unsanitized_post;
        //Load company data
        if (!is_null($company = $this->Company_model->get_company($this->company_id))) {
            $data['company'] = $company;
        }
        $check_in_policies       = isset($unsanitized_post['check-in-policies']) ? $unsanitized_post['check-in-policies'] : "" ;
        $reservation_policies    = isset($unsanitized_post['reservation-policies']) ? $unsanitized_post['reservation-policies'] : "" ;
        $this->form_validation->set_rules('reservation-policies', 'Reservation policies');
        $this->form_validation->set_rules('check-in-policies', 'Check-in policies');

        if ($this->form_validation->run() == true) {
            $this->Company_model->update_company($this->company_id, Array('check_in_policies' => $check_in_policies, 'reservation_policies' => $reservation_policies));
            $this->_create_employee_log("Company policies updated.");
            redirect('company/policies'); // redirect to settings unavailable screen
        }
        $policies = $this->Company_model->get_policies($this->company_id);

        $data['check_in_policies'] = $policies->check_in_policies;
        
        $data['reservation_policies'] = $policies->reservation_policies;

        $this->ckeditor->basePath = base_url().'application/third_party/ckeditor/';
        $this->ckeditor->config['language'] = 'en';
        //Add Ckfinder to Ckeditor
        $this->ckfinder->SetupCKEditor($this->ckeditor,'../../ckfinder/'); 

        $files = get_asstes_files($this->module_assets_files, $this->module_name, $this->controller_name, $this->function_name);
        // prx($files);

        $data['company_ID'] = $this->company_id;

        $data['selected_sidebar_link'] = 'Policies';

        $data['main_content'] = '../extensions/'.$this->module_name.'/views/policies';
        $this->template->load('bootstrapped_template', null , $data['main_content'], $data);
    }

    function _create_employee_log($log) {
        $log_detail =  array(
            "user_id" => $this->user_id,
            "selling_date" => $this->selling_date,
            "date_time" => gmdate('Y-m-d H:i:s'),
            "log" => $log,
        );


        $this->Employee_log_model->insert_log($log_detail);
    }
}